﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="System.Linq" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.EwidencjaVat" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
    
    <title>Zestawienie zbiorcze VAT</title>
    <meta name="GENERATOR" Content="Microsoft Visual Studio 7.0">
    <meta name="CODE_LANGUAGE" Content="C#">
    <meta name="vs_defaultClientScript" content="JavaScript">
    <meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
    <script runat="server">
      void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
				SumaKategorii sk = (SumaKategorii)args.Row;
				if (param.DefinicjeStawekVAT != null && param.DefinicjeStawekVAT.Length != 0) {
					int idx = Grid1.Columns.IndexOf(colOpis);
					foreach (DefinicjaStawkiVat defVAT in param.DefinicjeStawekVAT) {
						GridColumn colNetto = Grid1.Columns[++idx];
						colNetto.EditValue = sk.wgKoduStawki.ContainsKey(defVAT.Kod) ? sk.wgKoduStawki[defVAT.Kod].Netto.Value : 0m;

						GridColumn colVAT = Grid1.Columns[++idx];
						colVAT.EditValue = sk.wgKoduStawki.ContainsKey(defVAT.Kod) ? sk.wgKoduStawki[defVAT.Kod].VAT.Value : 0m;

						GridColumn colBrutto = Grid1.Columns[++idx];
						colBrutto.EditValue = sk.wgKoduStawki.ContainsKey(defVAT.Kod) ? sk.wgKoduStawki[defVAT.Kod].Brutto.Value : 0m;
					}
				}				
      }

			public class NettoVATBrutto {
				Currency netto, vat, brutto;

				static public NettoVATBrutto Zero = new NettoVATBrutto(0, 0, 0);
				
				internal NettoVATBrutto(Currency netto, Currency vat, Currency brutto) {
					this.netto = netto;
					this.vat = vat;
					this.brutto = brutto;
				}

				internal NettoVATBrutto(Soneta.EwidencjaVat.NettoVATBrutto nvb) {
					this.netto = nvb.Netto;
					this.vat = nvb.VAT;
					this.brutto = nvb.Brutto;
				}				

				internal void Add(Currency netto, Currency vat, Currency brutto) {
					this.netto += netto;
					this.vat += vat;
					this.brutto += brutto;
				}

				internal void Add(Soneta.EwidencjaVat.NettoVATBrutto nvb) {
					this.netto += nvb.Netto;
					this.vat += nvb.VAT;
					this.brutto += nvb.Brutto;
				}
				
				public Currency Netto { get { return netto; } }
				public Currency VAT { get { return vat; } }
				public Currency Brutto { get { return brutto; } }

			}

			
			[System.ComponentModel.TypeConverter(typeof(StringSubTableConverter))]
			public class SumaKategorii 
			{
				readonly OddzialFirmy oddzialFirmy = null;
				readonly object obiektKategorii = null;
				
				readonly string opis = "";
				StringCollection kodyStawek = null;
				internal Dictionary<string, NettoVATBrutto> wgKoduStawki = new Dictionary<string, NettoVATBrutto>();

				public SumaKategorii(OddzialFirmy o, object obiekt) 
				{
					oddzialFirmy = o;
					obiektKategorii = obiekt;
					
					if (obiekt is DefinicjaDokumentu)
						opis = ((DefinicjaDokumentu)obiekt).Symbol;
					else if(obiekt is TypDokumentu)
						opis = CaptionAttribute.EnumToString((TypDokumentu)obiekt);
					else
						throw new ArgumentException("Nieobsługiwany obiekt kategorii");
				}
				

				public object ObiektKategorii
				{ get { return obiektKategorii; } }

				public OddzialFirmy Oddzial
				{ get { return oddzialFirmy; } }

				public String NazwaOddzialu
				{ get { return oddzialFirmy != null ? "Oddział " + oddzialFirmy.ToString() : "(bez oddziału)"; } }

				public string Opis
				{ get { return opis; } }				

				
				public static IEnumerable GetNames(Session session) {
					return Soneta.EwidencjaVat.NettoVATBruttoWgStawek.GetNames(session);
				}

				public NettoVATBrutto this[string kodStawki] {
					get {
						if (wgKoduStawki.ContainsKey(kodStawki))
							return wgKoduStawki[kodStawki];
						return NettoVATBrutto.Zero;
					}
				}

				public void Add(PodsumowanieVATEx podsumowanie) {
					if (kodyStawek == null) {
						kodyStawek = new StringCollection();
						foreach (string kod in SumaKategorii.GetNames(podsumowanie.Naglowek.Session))
							kodyStawek.Add(kod);
					}

					foreach (string kod in kodyStawek) {
						Soneta.EwidencjaVat.NettoVATBrutto nvb = podsumowanie.SumaWgStawek[kod];
						if (nvb.Netto.Value == 0 && nvb.VAT.Value == 0 && nvb.Brutto.Value == 0)
							continue;
						
						netto += nvb.Netto;
						vat += nvb.VAT;
						brutto += nvb.Brutto;						
												
						if (!wgKoduStawki.ContainsKey(kod))
							wgKoduStawki.Add(kod, new NettoVATBrutto(nvb));
						else
							wgKoduStawki[kod].Add(nvb);
					}
					
				}
				
				Currency netto = Currency.Zero; Currency vat = Currency.Zero; Currency brutto = Currency.Zero; 
				public Currency Netto {
					get { return netto; }
				}

				public Currency VAT {
					get { return vat; }
				}

				public Currency Brutto {
					get { return brutto; }
				}

				public NettoVATBrutto NP {
					get { return wgKoduStawki.ContainsKey("NP") ? wgKoduStawki["NP"] : NettoVATBrutto.Zero; }
				}

                public NettoVATBrutto Brak
                {
                    get { return wgKoduStawki.ContainsKey("-") ? wgKoduStawki["-"] : NettoVATBrutto.Zero; }
                }                

				public NettoVATBrutto ZW {
					get { return wgKoduStawki.ContainsKey("ZW") ? wgKoduStawki["ZW"] : NettoVATBrutto.Zero; }
				}

				public NettoVATBrutto OP0 {
					get { return wgKoduStawki.ContainsKey("0%") ? wgKoduStawki["0%"] : NettoVATBrutto.Zero; }
				}

				public NettoVATBrutto OP3 {
					get { return wgKoduStawki.ContainsKey("3%") ? wgKoduStawki["3%"] : NettoVATBrutto.Zero; }
				}

				public NettoVATBrutto OP6 {
					get { return wgKoduStawki.ContainsKey("6%") ? wgKoduStawki["6%"] : NettoVATBrutto.Zero; }
				}

				public NettoVATBrutto OP7 {
					get { return wgKoduStawki.ContainsKey("7%") ? wgKoduStawki["7%"] : NettoVATBrutto.Zero; }
				}

				public NettoVATBrutto OP12 {
					get { return wgKoduStawki.ContainsKey("12%") ? wgKoduStawki["12%"] : NettoVATBrutto.Zero; }
				}

				public NettoVATBrutto OP22 {
					get { return wgKoduStawki.ContainsKey("22%") ? wgKoduStawki["22%"] : NettoVATBrutto.Zero; }
				}																		
				
			}

			public enum TypZestawieniaZbiorczegoVAT {
				WgDefinicjiEwidencji,
				WgTypuEwidencji,
			}
    	

    	public class Params : SerializableContextBase
		{
			private Boolean oddzialowoscEnabled ;

				public Params(Context cx)
					: base(cx)
				{
					OddzialParamsBase opb = (OddzialParamsBase)cx[typeof(OddzialParamsBase),false];
					grupowanieWgOddzialow = oddzialowoscEnabled = opb!=null && opb.OddzialowoscEnabled;
				}

				TypZestawieniaZbiorczegoVAT typZestawienia = TypZestawieniaZbiorczegoVAT.WgDefinicjiEwidencji;
				[Soneta.Tools.Priority(1)]				
				public TypZestawieniaZbiorczegoVAT TypZestawienia {
					get { return typZestawienia; }
					set { typZestawienia = value; }
				}

				DefinicjaStawkiVat[] definicjeStawekVAT = null;
				[Caption("Kolumny(stawki VAT)")]
				[Soneta.Tools.Priority(2)]
				[Required]
				public DefinicjaStawkiVat[] DefinicjeStawekVAT {
					get { return definicjeStawekVAT; }
					set { definicjeStawekVAT = value; }
				}


			
			public LookupInfo.Item GetListDefinicjeStawekVAT()
			{
				var coreModule = CoreModule.GetInstance(Session);

				var view = coreModule.DefStawekVat.CreateDefaultView();
				view.Condition &= new FieldCondition.NotEqual("Stawka.Procent", new Percent(0));
				view.Condition &= new FieldCondition.Equal("Stawka.Kraj", coreModule.KrajeTbl.Poland);

				return CoreModule.GetInstance(Session).DefStawekVat.GetDefaultLookup(view);
			}
				
				
				Boolean grupowanieWgOddzialow;
				[Caption("Grupuj wg oddziałów")]
				[Soneta.Tools.Priority(3)]
				public Boolean GrupowanieWgOddzialow
				{
					get { return grupowanieWgOddzialow; }
					set { grupowanieWgOddzialow = value; }
				}	


				public Boolean IsReadOnlyGrupowanieWgOddzialow ()
				{return !oddzialowoscEnabled; }
			}

    	Params param = null;
    	[Context]
			public Params Param {
				set { param = value; }
			}


		private SumaKategorii FindSum(List<SumaKategorii> sumyKategorii,OddzialFirmy keyOddzial,Object keyObj)
		{
			foreach (SumaKategorii sk in sumyKategorii)
				if (sk.Oddzial == keyOddzial && Object.Equals(keyObj, sk.ObiektKategorii))
					return sk;

			SumaKategorii sk2 = new SumaKategorii(keyOddzial, keyObj);
			sumyKategorii.Add(sk2);

			return sk2;
		}


		private int SumyKategoriiSortMethod(SumaKategorii s1, SumaKategorii s2)
		{
			if (s1.Oddzial != s2.Oddzial)
			{
				if (s1.Oddzial == null)
					return -1;
				if (s2.Oddzial == null)
					return 1;
				return s1.NazwaOddzialu.CompareTo(s2.NazwaOddzialu);
			}
			else
			{
				return s1.ObiektKategorii.ToString().CompareTo(s2.ObiektKategorii.ToString());
			}
		}

		
      void EwidencjaVAT_OnLoad(Object sender, EventArgs args)
	  {
		  
      NagEwidencjiVATT.ParamsEx p = (NagEwidencjiVATT.ParamsEx)DataContext1.Get(typeof(NagEwidencjiVATT.ParamsEx));
	  OddzialParamsBase opb = (OddzialParamsBase)DataContext1.Get(typeof(OddzialParamsBase));
		  
      bool rozliczenia = (p is NagRozliczenVATT.Params || p is NagRozliczenVATT.ParamsEx);
        string wg = "";

				PodsumowanieVATEx worker = new PodsumowanieVATEx();
				worker.Param = p;

				System.Collections.Generic.List<SumaKategorii> sumyKategorii = new System.Collections.Generic.List<SumaKategorii>();
		  
				foreach(INaglowekVAT nag in (Row[])DataContext1.Get(typeof(Row[])))
				{
					worker.Naglowek = nag;
					object keyObj = null;
					OddzialFirmy keyOddzial = param.GrupowanieWgOddzialow ? nag.Ewidencja.Oddzial : null;
					
					switch (param.TypZestawienia) 
					{
						case TypZestawieniaZbiorczegoVAT.WgDefinicjiEwidencji:
								keyObj = nag.Definicja; break;
						case TypZestawieniaZbiorczegoVAT.WgTypuEwidencji:
							keyObj = nag.Ewidencja.Typ; break;							
						default:
							throw new ArgumentException();						
					}

					SumaKategorii sk = FindSum(sumyKategorii, keyOddzial, keyObj);
					sk.Add(worker);
				}

				if (param.DefinicjeStawekVAT != null && param.DefinicjeStawekVAT.Length != 0) {
					int idx = Grid1.Columns.IndexOf(colOpis);
					foreach (DefinicjaStawkiVat defVAT in param.DefinicjeStawekVAT) {
						GridColumn gcNetto = new GridColumn();
						gcNetto.Caption = string.Format("Netto {0}", defVAT.Kod);
						gcNetto.Format = "{0:n}";
						gcNetto.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
						gcNetto.Total = Soneta.Web.Total.Sum;
						Grid1.Columns.Insert(++idx, gcNetto);
												
						GridColumn gcVAT = new GridColumn();
						gcVAT.Caption = string.Format("VAT {0}", defVAT.Kod);
						gcVAT.Format = "{0:n}";
						gcVAT.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
						gcVAT.Total = Soneta.Web.Total.Sum;
						Grid1.Columns.Insert(++idx, gcVAT);

						GridColumn gcBrutto = new GridColumn();
						gcBrutto.Caption = string.Format("Brutto {0}", defVAT.Kod);
						gcBrutto.Format = "{0:n}";
						gcBrutto.Align = System.Web.UI.WebControls.HorizontalAlign.Right;
						gcBrutto.Total = Soneta.Web.Total.Sum;
						Grid1.Columns.Insert(++idx, gcBrutto);						
					}
				}

				if (param.GrupowanieWgOddzialow)
				{
					Grid1.GroupLine = "{0}";
					Grid1.GroupData0 = "NazwaOddzialu";
					Grid1.ShowGroupSum = true;
				}

				sumyKategorii.Sort(SumyKategoriiSortMethod);
				Grid1.DataSource = sumyKategorii;

				switch (param.TypZestawienia) {
					case TypZestawieniaZbiorczegoVAT.WgDefinicjiEwidencji:
						wg = "definicji ewidencji";
						colOpis.Caption = "Definicja ewidencji";
						break;
					case TypZestawieniaZbiorczegoVAT.WgTypuEwidencji:
						wg = "typu ewidencji";
						colOpis.Caption = "Typ ewidencji";
						break;												
					default :
						throw new ArgumentException();
				}


				string tytul = "Zestawienie zbiorcze {0} VAT wg {1}";
				if (!rozliczenia)
					tytul = string.Format(tytul, "ewidencji", wg);
				else
					tytul = string.Format(tytul, "rozliczeń", wg);

				string tytulNaglowka =
									string.Format("{0}{10} | Typ ewidencji: {1}, Za okres: {2} | Definicja: {3}, Podmiot: {4}, Korekty: {5} |Działalność: {11}, Odliczenia: {6}|Rodzaj: {7}, Rodzaj pod.: {8}, Status pod.: {9}|{12}",
									tytul, p.Typ, p.Zakres, p.Definicja == null ? "Wszystkie" : p.Definicja.ToString(),
									p.Podmiot == null ? "Wszyscy" : p.Podmiot.ToString(), p.Korekty, CaptionAttribute.EnumToString(p.Odliczenia), p.RodzajZakupu, p.RodzajPodmiotu, p.StatusPodmiotu,
									param.GrupowanieWgOddzialow ? " | Oddział: " + opb.Oddział : string.Empty, CaptionAttribute.EnumToString(p.DzialalnoscGospodarcza), p.ApplyAspxParamsForProceduresVAT());


				if (p.Porownanie != TypPorownania.Brak)
					tytulNaglowka =
									string.Format("{0} | Kwota brutto {1} {2:n}",
										tytulNaglowka, CaptionAttribute.EnumToString(p.Porownanie), p.Kwota);

				ReportHeader1.Title = tytulNaglowka;
       
      }
	</script>
  </HEAD>
  <body>
    <form id="ZestawinieZbiorczeVAT" method="post" runat="server" onload="EwidencjaVAT_OnLoad">
      <ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business"></ea:DataContext><BR>
      <cc1:ReportHeader id="ReportHeader1" runat="server" title="{0} | Za okres: {1}"></cc1:ReportHeader><BR>
      <ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" ShowPrevAgrSum="InFooter" ShowPageSum="True" ShowAgrSum="True" RowTypeName="SumaKategorii" RowsInRow="3">
        <Columns>
          <ea:GridColumn Align="Center" DataMember="Opis" Total="Info" ID="colOpis" RowSpan="3"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="OP0.Netto.Value" Total="Sum" Caption="Netto 0%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="OP0.VAT.Value" Total="Sum" Caption="VAT 0%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="OP0.Brutto.Value" Total="Sum" Caption="Brutto 0%" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="NP.Netto.Value" Total="Sum" Caption="Wart. NP" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="ZW.Netto.Value" Total="Sum" Caption="Wart. Zw." Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Brak.Netto.Value" Total="Sum" Caption="Wart. '-'" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Netto.Value" Total="Sum" Caption="Netto" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="VAT.Value" Total="Sum" Caption="VAT" Format="{0:n}"></ea:GridColumn>
          <ea:GridColumn Align="Right" DataMember="Brutto.Value" Total="Sum" Caption="Brutto" Format="{0:n}"></ea:GridColumn>
        </Columns>
      </ea:Grid><BR>
      <cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
    </form>
  </body>
</HTML>

